#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Shirt Pattern #1Mode01.fsh   by    Darkensses 
//https://www.shadertoy.com/view/...
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

mat2 rot2D(float angle) {
    float s = sin(angle);
    float c = cos(angle);
    return mat2(c, -s, s, c);
}

float se(vec2 p, float k, float r) {
    p.x = abs(p.x);
    float x = pow(abs(p.x), k);
    float y = pow(abs(p.y), k);
    return x + y - r;
}

float sdBox( in vec2 p, in vec2 b ) {
    vec2 d = abs(p)-b;
    return length(max(d,0.0)) + min(max(d.x,d.y),0.0);
}

float sdTriangle(vec2 p, vec2 p0, vec2 p1, vec2 p2) {
    vec2 e0 = p1-p0, e1 = p2-p1, e2 = p0-p2;
    vec2 v0 = p -p0, v1 = p -p1, v2 = p -p2;
    vec2 pq0 = v0 - e0*clamp( dot(v0,e0)/dot(e0,e0), 0.0, 1.0 );
    vec2 pq1 = v1 - e1*clamp( dot(v1,e1)/dot(e1,e1), 0.0, 1.0 );
    vec2 pq2 = v2 - e2*clamp( dot(v2,e2)/dot(e2,e2), 0.0, 1.0 );
    float s = sign( e0.x*e2.y - e0.y*e2.x );
    vec2 d = min(min(vec2(dot(pq0,pq0), s*(v0.x*e0.y-v0.y*e0.x)),
                     vec2(dot(pq1,pq1), s*(v1.x*e1.y-v1.y*e1.x))),
                     vec2(dot(pq2,pq2), s*(v2.x*e2.y-v2.y*e2.x)));
    return -sqrt(d.x)*sign(d.y);
}

vec2 opRep(vec2 p, vec2 c) {
    return mod(p+0.5*c,c)-0.5*c;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord * 2. - iResolution.xy) / iResolution.y; 
    uv *= 1.;
    vec2 qq = uv-vec2(.75,.27);
    uv.y += iTime * 0.1;            
    vec3 col = vec3(1.);
    
    vec2 q = opRep(uv, vec2(1.5,.52));    
    
    float a = se(q*vec2(1.29,1.8), 1.66, .5);
    a = smoothstep(0.,.01,a);
    
    float b = se(q*vec2(.95,1.2), 1., .4);
    b = smoothstep(0.,.01,b);
    
    float c = se(q*vec2(.45, .4), .8, .2);
    c = smoothstep(0.,.005,c);
    
    float d, e, de; 
    d = se(q*vec2(1.5,.7), .8, .22);    
    e = sdBox(q, vec2(.005,.365)); 
    de = min(d*.5,e);  
    de = abs(de-.009) - .001;
    d = smoothstep(0.,.01,d);           
    e = smoothstep(0.,.01,e);
    de = smoothstep(0.,.01,de);
        
    float f = se(vec2(abs(q.x)-.11,q.y)*vec2(0.84,1.5), 1., .1);    
    f = smoothstep(0., .01, f);
    f = max(f,d);
           
    qq.y -= iTime * 0.1;      
    qq = opRep(qq, vec2(1.5, .52));    

    float g = sdBox(vec2(qq.x,abs(qq.y))-vec2(0,.245), vec2(.003,.1));
    g = smoothstep(0., .003, g);
    
    float hb = se(vec2(qq.x,qq.y)*vec2(0.38,0.28), 0.7, 0.12);    
    float h = smoothstep(0., 0.01, hb);        
    
    float i = 
    smoothstep(0., 0.02, se(vec2(qq.x,abs(qq.y)-0.26)*vec2(3,2.), 1., 0.16)) *
    smoothstep(0., 0.02, se(vec2(abs(qq.x)-0.055,abs(qq.y)-0.14)*vec2(3.5,2.2)*rot2D(0.15), 1., 0.18)) *
    smoothstep(0., 0.02, se(vec2(abs(qq.x)-0.11,abs(qq.y)-0.02)*vec2(3.5,3.5)*rot2D(0.4), 1., 0.25));     
    
    float j = sdTriangle(vec2(abs(qq.x)-(0.19+(cos(iTime*1.2)*0.03)),abs(qq.y))*vec2(4), vec2(0.),vec2(0.2,0.), vec2(-0.07,0.12)) - 0.01;
    j = smoothstep(0.,0.02, j);
    
    vec3 c1,c2,c3;
    c1 = vec3(0.74,0.27,0.23);
    c2 = vec3(0.35,0.17,0.15);
    c3 = vec3(0.85,0.60,0.26);
        
    col = mix(c1, col, j);
    col = mix(c2, col, a);
    col = mix(c1, col, b);
    col = mix(c3, col, c);
    col = mix(c2, col, d);
    col = mix(c2, col, e);
    col = mix(c1, col, f);
    col = mix(vec3(1), col, de);
    col = mix(c2, col, g);        
    col = mix(c1, col, i);
    col = mix(mix(c2,vec3(1.),smoothstep(0.0,0.01,abs(hb)-0.01)), col, h);    
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

